# Logo Collection - Image Metadata Tagger

This repository contains logos for Network School and related projects, all licensed under Creative Commons Attribution-ShareAlike 4.0 International (CC BY-SA 4.0).

## Metadata

All images in this collection are tagged with comprehensive Creative Commons metadata:

### Basic Metadata
- **dc:rights**: Creative Commons Attribution-ShareAlike 4.0 International (CC BY-SA 4.0)
- **cc:license**: https://creativecommons.org/licenses/by-sa/4.0/
- **dc:creator**: Network School
- **dc:source**: https://ns.com/about
- **dc:title**: Auto-generated from filename (e.g., "Network School Black")

### Extended Metadata
- **xmpRights:UsageTerms**: Licensed under CC BY-SA 4.0; attribution required.
- **xmpRights:Marked**: True
- **Iptc4xmpCore:CreatorContactInfo** (PNG) / **dc:publisher** (SVG): https://ns.com/support
- **dc:subject**: NS, Network School, The Network State, Network State Conference, Network State Podcast, ns.com

## Usage

### Tagging Images with Metadata

Two scripts are provided for adding metadata to all PNG and SVG files:

1. **Basic metadata** (license, creator, source, title):
```bash
./tag_images.py
# or
python3 tag_images.py
```

2. **Extended metadata** (usage terms, marked status, contact info, subjects):
```bash
./tag_images_extended.py
# or
python3 tag_images_extended.py
```

**Note**: Run both scripts to add all metadata fields to your images

### Requirements

For PNG files, the script requires `exiftool`:

**macOS:**
```bash
brew install exiftool
```

**Linux:**
```bash
sudo apt-get install libimage-exiftool-perl
```

**Windows:**
Download from https://exiftool.org/

For SVG files, only Python 3 (standard library) is required.

## What the Scripts Do

### `tag_images.py` (Basic Metadata)
1. **Finds all images**: Recursively searches for `.png` and `.svg` files
2. **Generates titles**: Converts filenames to human-readable titles (e.g., "network-school-black.png" → "Network School Black")
3. **Adds basic metadata**:
   - For PNG files: Embeds XMP metadata using exiftool
   - For SVG files: Adds RDF metadata directly to the XML structure
4. **Provides feedback**: Shows progress and summary of tagged files

### `tag_images_extended.py` (Extended Metadata)
1. **Finds all images**: Recursively searches for `.png` and `.svg` files
2. **Adds extended metadata**:
   - For PNG files: Uses exiftool to add XMP-xmpRights, IPTC, and dc:subject metadata
   - For SVG files: Directly modifies XML to add xmpRights, dc:publisher, and dc:subject
3. **Includes**:
   - Usage terms and licensing information
   - Creator contact information
   - Subject keywords for better searchability
4. **Provides feedback**: Shows progress and summary of tagged files

## License

All logos in this collection are licensed under [Creative Commons Attribution-ShareAlike 4.0 International (CC BY-SA 4.0)](https://creativecommons.org/licenses/by-sa/4.0/).

You are free to:
- **Share** — copy and redistribute the material in any medium or format
- **Adapt** — remix, transform, and build upon the material for any purpose, even commercially

Under the following terms:
- **Attribution** — You must give appropriate credit to Network School
- **ShareAlike** — If you remix, transform, or build upon the material, you must distribute your contributions under the same license

## Contents

- **network-school/** - Network School logos
- **network-state/** - Network State logos
- **ns-com/** - ns.com logos
- **ns-conference/** - NS Conference logos
- **ns-flag/** - NS Flag variations
- **ns-podcast/** - NS Podcast logos

Each directory contains both PNG and SVG versions in black and white variants.

## Support

For questions or support, contact: support@ns.com

For more information, visit: https://ns.com/about

